<?php

$path = pathinfo(__FILE__) ['dirname'];

include ($path . '/config.php');

$output = $video_output = $gradient_output = $effectsLayer = $underline_class = $skrollr_bg_output = $content_opacity = $title_force_font_size_class = $subtitle_force_font_size_class = '';
$half_section = $section_height / 2;
$id = Mk_Static_Files::shortcode_id();
$imageset = Mk_Image_Resize::get_bg_res_set($bg_image, $bg_image_portrait);

global $post;



///////////////////////////////////////////////////////////
//
// Prepare conditional output
//
//////////////////////////////////////////////////////////

/* Video layer */
if ( $bg_type == 'video' ) {

    if(!empty($video_preview)) {
            $video_output .= '<div style="background-image:url('.$video_preview.');" class="mk-video-section-touch"></div>';  
    }

    $video_output .= '<div class="mk-section-video"><video poster="'.$video_preview.'" muted="muted" preload="auto" loop="true" autoplay="true">';

    if ( !empty( $mp4 ) ) {
        //MP4 must be first for iPad!
        $video_output .= '<source type="video/mp4" src="'.$mp4.'" />';
    }
    if ( !empty( $webm ) ) {
        $video_output .= '<source type="video/webm" src="'.$webm.'" />';
    }
    if ( !empty( $ogv ) ) {
        $video_output .= '<source type="video/ogg" src="'.$ogv.'" />';
    }

    $video_output .= '</video></div>';
}
/***********/

/* Gradient layer */
if ($bg_effects == "gradient") { 
    $gradient_output .= '<div class="mk-effect-gradient-layer" data-top-top="opacity:0" data-'.$half_section.'="opacity: 1"></div>'; 
} 
/***********/

/* Effects layers holder */
if (!empty($bg_effects)) { 

    if ($bg_effects == "parallax") {
        $skrollr_bg_output = 'data-top-top="transform: translateY(0%)" data-top-bottom="transform: translateY(50%)"'; }
    if ($bg_effects == "parallaxZoomOut") {
        $skrollr_bg_output = 'data-top-top="transform: translateY(0%) scale(1.5)" data-top-bottom="transform: translateY(50%) scale(1)"';  }

    $effectsLayer .= '<div class="mk-section-preloader js-el" data-mk-component="Preloader">';
    $effectsLayer .= '     <div class="mk-section-preloader__icon"></div>';
    $effectsLayer .= '</div>';
    $effectsLayer .= '<div class="mk-effect-bg-layer ' .mk_get_bg_cover_class($bg_stretch). '" '. $skrollr_bg_output .' data-effect="' .$bg_effects. '" ';
    if (!empty($bg_effects) && $bg_type != 'color') { $effectsLayer .= $imageset; }
    $effectsLayer .= '>';
    $effectsLayer .=    $gradient_output . $video_output;
    $effectsLayer .= '</div>'; 
} else {
    $effectsLayer .= $video_output;
}
/***********/

/* Effects layers holder */
if (!empty($bg_effects) && $bg_effects != "gradient") {
    $content_opacity = 'data-top-top="opacity: 1" data-'.$half_section.'="opacity: 0"';
}
/***********/

/* 
* Underline class
*/
if($underline == "true") {
    $underline_class = " mk-page-title-box-title--underline";
}
/***********/


/* 
* Title Force font size class
*/
if ($title_force_font_size == 'true') {
    $title_force_font_size_class = " mk-page-title-box--forcefont";
}
/***********/


/* 
* Subtitle Force font size class
*/
if ($subtitle_force_font_size == 'true') {
    $subtitle_force_font_size_class = " mk-page-title-box--forcefont-subtitle";
}
/***********/


///////////////////////////////////////////////////////////
//
// HTML output
//
//////////////////////////////////////////////////////////

if (!empty($bg_effects)) { 
$output .= '<div class="mk-effect-wrapper">'; }

if(!empty($overlay)) {
    $output .= '<div style="opacity: 1 !important; background-color:' . $overlay . ';" class="mk-video-color-mask"></div>';
}

$output .= '    <div id="mk-page-title-box-' .$id. '" class="mk-page-title-box ' . $subtitle_force_font_size_class . ' ' . $title_force_font_size_class . ' ' .mk_get_bg_cover_class($bg_stretch). ' '.$el_class . ' ' . $visibility . '"';
if(empty($bg_effects)) { $output .= $imageset; }
$output .= '    >';
$output .= '        '.$effectsLayer;
$output .= '        <div class="mk-page-title-box-content" '.$content_opacity.'>';
$output .= '            <div class="mk-grid">';
$output .= '                <h1 class="mk-page-title-box-title'. $underline_class .'">' .$page_title. '</h1>';
$output .= '                <div class="mk-page-title-box-subtitle">' .$page_subtitle. '</div>';
$output .= '            </div>';
$output .= '        </div><!-- mk-page-title-box-content -->';
$output .= '    </div><!-- mk-page-title-box -->';

if (!empty($bg_effects)) { 
$output .= '</div><!-- mk-effect-wrapper -->'; }

///////////////////////////////////////////////////////////
//
// Custom CSS generated by user choice via admin metabox
//
//////////////////////////////////////////////////////////



// Lets roll
echo $output;

$app_styles = '';
$app_styles .= "
    #mk-page-title-box-{$id} {
        height: {$section_height}px;
        background-color: {$bg_color};
        background-repeat: {$bg_repeat};
        text-align: {$text_align};";
        if (empty($bg_effects)) { 
            $app_styles .= "
                background-attachment:{$attachment};
                background-position:{$bg_position};
            "; 
        }
    $app_styles .= "
    }";
    $app_styles .= "
    #mk-page-title-box-{$id} .mk-page-title-box-title {
        font-size: {$font_size}px;
        line-height: {$font_size}px;
        font-weight: {$font_weight};
        color: {$font_color};
        padding-bottom: {$padding}px;
        margin-bottom: {$padding}px;
        letter-spacing: {$title_letter_spacing}px;
        text-transform: initial;
    }
    #mk-page-title-box-{$id} .mk-page-title-box-title--underline:after {
        background: {$font_color};";
        if ($text_align == "left") { $app_styles .="
        left: 0;
        margin: 0;";
        } else if ($text_align == "right") { $app_styles .="
        right: {$title_letter_spacing}px;
        left: auto;
        margin: 0;"; }
    $app_styles .= "}
    #mk-page-title-box-{$id} .mk-page-title-box-subtitle {
        font-size: {$sub_font_size}px;
        line-height: {$sub_font_size}px;
        font-weight: {$sub_font_weight};
        color: {$sub_font_color};";
        if ($text_align == "right") { $app_styles .="
        margin-right: {$title_letter_spacing}px; "; }
    $app_styles .= "}";
    if (!empty($bg_effects) && $bg_type != 'color') { $app_styles .= "
    #mk-page-title-box-{$id} .mk-effect-bg-layer {
        background-position:{$bg_position};
    }"; }


if ($title_force_font_size == 'true') {
    if($title_size_smallscreen != '0'){
        $app_styles .= '
            @media handheld, only screen and (max-width: 1280px) {
                #mk-page-title-box-' . $id . ' .mk-page-title-box-title {
                    font-size: '.$title_size_smallscreen.'px;
                }
            }
        ';
    } 
    if($title_size_tablet != '0') {
        $app_styles .= '
            @media handheld, only screen and (min-width: 768px) and (max-width: 1024px) {
                #mk-page-title-box-' . $id . ' .mk-page-title-box-title {
                    font-size: '.$title_size_tablet.'px;
                }
            }
        ';
    }
    if($title_size_phone != '0') {
        $app_styles .= '
            @media handheld, only screen and (max-width: 767px) {
                #mk-page-title-box-' . $id . ' .mk-page-title-box-title {
                    font-size: '.$title_size_phone.'px;
                }
            }
        ';
    }
}


if ($subtitle_force_font_size == 'true') {
    if($subtitle_size_smallscreen != '0'){
        $app_styles .= '
            @media handheld, only screen and (max-width: 1280px) {
                #mk-page-title-box-' . $id . ' .mk-page-title-box-subtitle {
                    font-size: '.$subtitle_size_smallscreen.'px;
                }
            }
        ';
    } 
    if($subtitle_size_tablet != '0') {
        $app_styles .= '
            @media handheld, only screen and (min-width: 768px) and (max-width: 1024px) {
                #mk-page-title-box-' . $id . ' .mk-page-title-box-subtitle {
                    font-size: '.$subtitle_size_tablet.'px;
                }
            }
        ';
    }
    if($subtitle_size_phone != '0') {
        $app_styles .= '
            @media handheld, only screen and (max-width: 767px) {
                #mk-page-title-box-' . $id . ' .mk-page-title-box-subtitle {
                    font-size: '.$subtitle_size_phone.'px;
                }
            }
        ';
    }
}

Mk_Static_Files::addCSS($app_styles, $id);


